<?php
define('BOT_TOKEN', 'توکن_ربات_خودت');
define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');
define('CHANNEL_ID', '-1001234567890');
define('ADMINS', [123456789]);

define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'realestate_bot');

if (getenv('BOT_SECRET_KEY')) {
    define('BOT_SECRET_KEY', base64_decode(getenv('BOT_SECRET_KEY')));
} else {
    die("❌ BOT_SECRET_KEY در محیط تنظیم نشده.");
}

define('DEFAULT_MAX_ADS_PER_MONTH', 6);
define('DEFAULT_AD_EXPIRY_DAYS', 30);

function apiRequest($method, $params = []) {
    $url = API_URL . $method;
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => $params
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}
