<?php
require_once 'functions.php';
require_once 'state.php';

$update = json_decode(file_get_contents('php://input'), true);
$chat_id = $update['message']['chat']['id'] ?? $update['callback_query']['message']['chat']['id'];
$text = $update['message']['text'] ?? '';
$data_cb = $update['callback_query']['data'] ?? null;

if($chat_id != ADMIN_ID) exit; // فقط مدیر

$pdo = db();
$state = getUserState($chat_id);

// ---------- منوی اصلی مدیریت ----------
if(empty($state) && $text){
    $buttons = [
        [['text'=>'📌 آگهی‌های در انتظار تایید']],
        [['text'=>'📌 آمار کلی']],
        [['text'=>'📌 پیام همگانی']],
        [['text'=>'📌 تنظیمات']],
        [['text'=>'📌 دریافت PDF آگهی‌ها']]
    ];
    sendButton($chat_id,"👑 منوی مدیریت:",$buttons);
    exit;
}

// ---------- آگهی‌های در انتظار تایید ----------
if($text=='📌 آگهی‌های در انتظار تایید'){
    $stmt = $pdo->prepare("SELECT * FROM ads WHERE status='pending'");
    $stmt->execute();
    $ads = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if(!$ads) sendMessage($chat_id,"📭 هیچ آگهی در انتظار تایید وجود ندارد.");
    else{
        foreach($ads as $ad){
            $msg = "🆔 #{$ad['id']} | {$ad['ad_type']} {$ad['property_type']}\n".
                   "✳️ عنوان: {$ad['title']}\n".
                   "💵 قیمت: {$ad['price']}\n".
                   "👤 آگهی دهنده: ".decrypt($ad['first_name'])." ".decrypt($ad['last_name']);
            $buttons = [[
                ['text'=>'✅ تایید','callback_data'=>'approve_'.$ad['id']],
                ['text'=>'❌ رد','callback_data'=>'reject_'.$ad['id']]
            ]];
            sendButton($chat_id,$msg,$buttons);
        }
    }
    exit;
}

// ---------- تایید و رد آگهی ----------
if($data_cb && (strpos($data_cb,'approve_')===0 || strpos($data_cb,'reject_')===0)){
    $ad_id = str_replace(['approve_','reject_'], '', $data_cb);
    $stmt = $pdo->prepare("SELECT * FROM ads WHERE id=?");
    $stmt->execute([$ad_id]);
    $ad = $stmt->fetch(PDO::FETCH_ASSOC);
    if(!$ad) exit;

    $user_id = $ad['user_id'];
    if(strpos($data_cb,'approve_')===0){
        $stmt = $pdo->prepare("UPDATE ads SET status='approved',created_at=?,expire_at=? WHERE id=?");
        $expire = date('Y-m-d', strtotime('+'.AD_EXPIRE_DAYS.' days'));
        $stmt->execute([today_shamsi(),$expire,$ad_id]);
        sendMessage($user_id,"✅ آگهی شما با عنوان '{$ad['title']}' تایید شد.");
        sendAdToChannel($user_id,$ad);
    } else {
        $stmt = $pdo->prepare("UPDATE ads SET status='rejected' WHERE id=?");
        $stmt->execute([$ad_id]);
        sendMessage($user_id,"❌ آگهی شما با عنوان '{$ad['title']}' رد شد.");
    }
    sendMessage($chat_id,"✅ عملیات انجام شد.");
    exit;
}

// ---------- آمار کلی ----------
if($text=='📌 آمار کلی'){
    $users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $ads = $pdo->query("SELECT COUNT(*) FROM ads")->fetchColumn();
    $blocked = 0; // ساده سازی، کاربران مسدود در این نسخه صفر است
    sendMessage($chat_id,"📊 آمار کلی:\n👤 تعداد کاربران: $users\n🏷 تعداد آگهی‌ها: $ads\n🚫 کاربران مسدود: $blocked");
    exit;
}

// ---------- پیام همگانی ----------
if($text=='📌 پیام همگانی'){
    sendMessage($chat_id,"📝 لطفاً متن پیام همگانی را ارسال کنید:");
    setUserState($chat_id,['step'=>'broadcast']);
    exit;
}
if($state['step']=='broadcast' && $text){
    $stmt = $pdo->query("SELECT id FROM users");
    $users = $stmt->fetchAll(PDO::FETCH_COLUMN);
    foreach($users as $u){
        sendMessage($u,$text);
    }
    clearUserState($chat_id);
    sendMessage($chat_id,"✅ پیام همگانی ارسال شد.");
    exit;
}

// ---------- تنظیمات ----------
if($text=='📌 تنظیمات'){
    $msg = "⚙️ تنظیمات فعلاً از طریق تغییر مستقیم config.php و دیتابیس قابل ویرایش است:\n".
           "- تعداد آگهی هر کاربر\n".
           "- مدت اعتبار آگهی\n".
           "- متن خوش آمد و ثبت نام موفق\n".
           "- آی‌دی کانال";
    sendMessage($chat_id,$msg);
    exit;
}

// ---------- دریافت PDF آگهی‌ها ----------
if($text=='📌 دریافت PDF آگهی‌ها'){
    require 'vendor/autoload.php'; // TCPDF
    $stmt = $pdo->query("SELECT * FROM ads WHERE status='approved'");
    $ads = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $pdf = new TCPDF();
    $pdf->AddPage();
    foreach($ads as $ad){
        $pdf->Write(0,"🆔 #{$ad['id']} | {$ad['ad_type']} {$ad['property_type']}\n".
                     "✳️ عنوان: {$ad['title']}\n".
                     "💵 قیمت: {$ad['price']}\n".
                     "👤 آگهی دهنده: ".decrypt($ad['first_name'])." ".decrypt($ad['last_name'])."\n\n");
    }
    $file = "/tmp/ads.pdf";
    $pdf->Output($file,'F');
    sendMessage($chat_id,"✅ PDF آماده شد: ".$file);
    exit;
}
